/*
 * Decompiled with CFR 0.152.
 */
package ch.aplu.jaw;

import ch.aplu.jaw.NativeHandler;
import ch.aplu.jaw.NativeKeyListener;
import ch.aplu.jaw.NativeMouse;
import ch.aplu.jaw.NativeMouseListener;
import ch.aplu.jaw.SwingImageCreator;
import ch.aplu.jaw.TrayIconListener;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class JawGadget {
    String imagePath;
    String windowTitle;
    String enumInfo;
    boolean isTopMost;
    private NativeHandler nh;
    private GadgetEventThread gadgetEventThread;
    private String dll = "jawgadget";
    private boolean isWindowVisible = true;
    private boolean isImageLoaded = false;
    private NativeKeyListener nativeKeyListener = null;
    private NativeMouseListener nativeMouseListener = null;
    private NativeMouse mouse = new NativeMouse();
    private volatile boolean isThreadRunning;
    private volatile boolean isEventsEnabled;

    public JawGadget(boolean changeCursor) {
        this.nh = new NativeHandler(this.dll, this, 0, "", 0, 0, 1, 1, 0x80000020L);
        this.nh.expose(this);
        if (changeCursor) {
            this.nh.invoke(-4);
        }
    }

    public JawGadget() {
        this(false);
    }

    public void showImage(String imagePath, int percent, Color color, boolean isTopMost, int ulx, int uly) {
        this.isTopMost = isTopMost;
        this.loadImage(imagePath, new Point(ulx, uly), percent, color.getRed(), color.getGreen(), color.getBlue());
    }

    public void showImage(String imagePath, int percent, Color color, boolean isTopMost) {
        this.isTopMost = isTopMost;
        this.loadImage(imagePath, null, percent, color.getRed(), color.getGreen(), color.getBlue());
    }

    public void showImage(String imagePath, int percent, boolean isTopMost, int ulx, int uly) {
        this.isTopMost = isTopMost;
        this.loadImage(imagePath, new Point(ulx, uly), percent, 255, 255, 255);
    }

    public void showImage(String imagePath, int percent, boolean isTopMost) {
        this.isTopMost = isTopMost;
        this.loadImage(imagePath, null, percent, 255, 255, 255);
    }

    public void hideImage() {
        this.nh.hideWindow();
    }

    public void destroy() {
        if (this.isThreadRunning) {
            this.isThreadRunning = false;
            try {
                this.gadgetEventThread.join(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.nh.destroy();
    }

    public void addNativeMouseListener(NativeMouseListener listener, int mouseEventMask) {
        this.nh.flushBuf();
        this.nativeMouseListener = listener;
        this.nh.invoke(mouseEventMask);
        if (!this.isThreadRunning) {
            this.isThreadRunning = true;
            this.isEventsEnabled = true;
            this.gadgetEventThread = new GadgetEventThread();
            this.gadgetEventThread.start();
        }
    }

    public void addNativeKeyListener(NativeKeyListener listener) {
        this.nativeKeyListener = listener;
    }

    public void addTrayIconListener(TrayIconListener listener, int iconEventMask) {
        this.nh.addTrayIconListener(listener, iconEventMask);
    }

    public void addTrayIconListener(TrayIconListener listener) {
        this.nh.addTrayIconListener(listener, 2);
    }

    public void showIcon(String iconPath, String tooltip) {
        this.nh.showIcon(iconPath, tooltip);
    }

    public void showIcon(String iconPath) {
        this.nh.showIcon(iconPath);
    }

    public void hideIcon() {
        this.nh.hideIcon();
    }

    public void showBalloonTooltip(String title, String text, int flag, int timeout) {
        this.nh.showBalloonTooltip(title, text, flag, timeout);
    }

    public void showBalloonTooltip(String title, String text, int flag) {
        this.nh.showBalloonTooltip(title, text, flag, 2000);
    }

    public void showBalloonTooltip(String title, String text) {
        this.nh.showBalloonTooltip(title, text, 0, 2000);
    }

    public void sleep(int time) {
        try {
            Thread.currentThread();
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void writeBMP(JComponent component, File file) {
        BufferedImage bi = SwingImageCreator.createImage(component, 5);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            ImageIO.write((RenderedImage)bi, "BMP", fos);
            fos.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't create BMP image");
        }
    }

    public void writeBMP(JComponent component, String pathname) {
        this.writeBMP(component, new File(pathname));
    }

    public void enableMouseEvents(boolean enable) {
        this.isEventsEnabled = enable;
    }

    public boolean activate() {
        int rc = this.nh.invoke(-2);
        return rc != 0;
    }

    public boolean activate(String windowTitle) {
        this.windowTitle = windowTitle;
        int rc = this.nh.invoke(-3);
        return rc != 0;
    }

    public int getX() {
        return this.nh.invoke(-6);
    }

    public int getY() {
        return this.nh.invoke(-7);
    }

    public String enumWindows() {
        this.nh.invoke(-8);
        return this.enumInfo;
    }

    public void setPosition(int ulx, int uly) {
        this.nh.setWindowPosition(ulx, uly);
    }

    private void loadImage(String imagePath, Point ulc, int percent, int red, int green, int blue) {
        if (imagePath != null) {
            this.imagePath = this.getFullPath(imagePath);
            this.nh.invoke(-1);
            this.isImageLoaded = true;
        } else if (!this.isImageLoaded) {
            throw new RuntimeException("showImage() with imagePath = null, but image not yet loaded.");
        }
        if (ulc != null) {
            this.nh.setWindowPosition(ulc.x, ulc.y);
        }
        if (imagePath != null) {
            this.nh.showWindow(percent, red, green, blue, true);
        } else {
            this.nh.showWindow(percent, red, green, blue, false);
        }
    }

    private String getFullPath(String imagePath) {
        boolean fileFound = false;
        String fileName = "";
        String userHome = "";
        File imageFile = new File(imagePath);
        String fullPath = imageFile.getAbsolutePath();
        fileName = imageFile.getName();
        if (imageFile.exists()) {
            fileFound = true;
        }
        if (fileFound) {
            return fullPath;
        }
        throw new RuntimeException("Image file\n" + fileName + "\nnot found " + "in given or default directory");
    }

    private class GadgetEventThread
    extends Thread {
        int[] values = new int[3];

        GadgetEventThread() {
            JawGadget.this.nh.createBuf(this.values, 1000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int waitCycle = 0;
            while (JawGadget.this.isThreadRunning) {
                if (JawGadget.this.isEventsEnabled) {
                    NativeMouseListener nativeMouseListener = JawGadget.this.nativeMouseListener;
                    synchronized (nativeMouseListener) {
                        if (JawGadget.this.nh.readBuf(3) == 3) {
                            JawGadget.this.mouse.setValues(this.values[0], this.values[1], this.values[2]);
                            JawGadget.this.nativeMouseListener.mouseEvent(JawGadget.this.mouse);
                        }
                        if (JawGadget.this.nativeKeyListener != null) {
                            if (waitCycle == 0) {
                                waitCycle = 10;
                                int keyCodeExt = JawGadget.this.nh.invoke(-5);
                                if (keyCodeExt != 0) {
                                    int keyCode = keyCodeExt & 0xFF;
                                    int modifier = (keyCodeExt & 0xFF00) >> 8;
                                    JawGadget.this.nativeKeyListener.keyPressed(keyCode, modifier);
                                }
                            } else {
                                --waitCycle;
                            }
                        }
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

