/*
 * Decompiled with CFR 0.152.
 */
package ch.aplu.jaw;

import ch.aplu.jaw.NativeHandler;

public class SoundTouch {
    private NativeHandler nh = new NativeHandler("soundtouch");
    public static final int SETTING_USE_AA_FILTER = 0;
    public static final int SETTING_AA_FILTER_LENGTH = 1;
    public static final int SETTING_USE_QUICKSEEK = 2;
    public static final int SETTING_SEQUENCE_MS = 3;
    public static final int SETTING_SEEKWINDOW_MS = 4;
    public static final int SETTING_OVERLAP_MS = 5;
    private String versionString;
    private float newRate;
    private float newTempo;
    private float newPitch;
    private int newPitchInt;
    private int numChannels;
    private int srate;
    private byte[] inBuffer;
    private int numBytes;
    private int settingId;
    private int value;
    private byte[] outBuffer;
    private int maxBytes;
    private int maxSamples;

    public SoundTouch() {
        this.nh.expose(this);
    }

    public void destroy() {
        this.nh.destroy();
    }

    public String getVersionString() {
        this.nh.invoke(0);
        return this.versionString;
    }

    public int getVersionId() {
        return this.nh.invoke(1);
    }

    public void setRate(float newRate) {
        this.newRate = newRate;
        this.nh.invoke(2);
    }

    public void setTempo(float newTempo) {
        this.newTempo = newTempo;
        this.nh.invoke(3);
    }

    public void setRateChange(float newRate) {
        this.newRate = newRate;
        this.nh.invoke(4);
    }

    public void setTempoChange(float newTempo) {
        this.newTempo = newTempo;
        this.nh.invoke(5);
    }

    public void setPitch(float newPitch) {
        this.newPitch = newPitch;
        this.nh.invoke(6);
    }

    public void setPitchOctaves(float newPitch) {
        this.newPitch = newPitch;
        this.nh.invoke(7);
    }

    public void setPitchSemiTones(int newPitch) {
        this.newPitchInt = this.newPitchInt;
        this.nh.invoke(8);
    }

    public void setPitchSemiTones(float newPitch) {
        this.newPitch = newPitch;
        this.nh.invoke(9);
    }

    public void setChannels(int numChannels) {
        this.numChannels = numChannels;
        this.nh.invoke(10);
    }

    public void setSampleRate(int srate) {
        this.srate = srate;
        this.nh.invoke(11);
    }

    public void flush() {
        this.nh.invoke(12);
    }

    public void putSamples(byte[] inBuffer, int numBytes) throws RuntimeException {
        this.inBuffer = inBuffer;
        this.numBytes = numBytes;
        this.nh.invoke(13);
    }

    public void clear() {
        this.nh.invoke(14);
    }

    public boolean setSetting(int settingId, int value) {
        this.settingId = settingId;
        this.value = value;
        int rc = this.nh.invoke(15);
        return rc == 1;
    }

    public int getSetting(int settingId) {
        this.settingId = settingId;
        return this.nh.invoke(16);
    }

    public int numUnprocessedSamples() {
        return this.nh.invoke(17);
    }

    public int receiveSamples(byte[] outBuffer, int maxBytes) {
        this.outBuffer = outBuffer;
        this.maxBytes = maxBytes;
        return this.nh.invoke(18);
    }

    public int receiveSamples(int maxSamples) {
        this.maxSamples = maxSamples;
        return this.nh.invoke(19);
    }

    public int numSamples() {
        return this.nh.invoke(20);
    }

    public int isEmpty() {
        return this.nh.invoke(21);
    }

    private void throwRuntimeException() {
        throw new RuntimeException("Runtime error occurred when calling native putSample()");
    }
}

